function img=Snap_Image(core)

% This function snaps one image using the initialized Camera through the
% MicroManager software, and return the image in Matlab order. For more
% information go to https://micro-manager.org/wiki/Matlab_Configuration.

        core.setExposure(25); % set exposure time
        core.snapImage(); % snape the image 
        img = core.getImage();  % returned as a 1D array of signed integers in row-major order
%          
        width = core.getImageWidth(); % return the image width
        height = core.getImageHeight(); % return the image height
        if core.getBytesPerPixel == 2 % assign pixel types based on haw many bytes per pixel
        pixelType = 'uint16';
        else
        pixelType = 'uint8';
        end
        img = typecast(img, pixelType);      % pixels must be interpreted as unsigned integers
        img = reshape(img, [width, height]); % image should be interpreted as a 2D array
        img = transpose(img);                % make column-major order for MATLAB
        

img = imadjust(img,[0.01 0.1]);% Adjust image contrast by specifying contrast limits.

